<?php $__env->startSection('content'); ?>
    <!-- account section start -->
    <section class=" pt-100 pb-100 position-relative z-index-2">
        <div class="ball-1"><img src="<?php echo e(asset($activeTemplateTrue.'images/elements/ball-1.png')); ?>" alt="image"></div>
        <div class="ball-2"><img src="<?php echo e(asset($activeTemplateTrue.'images/elements/ball-2.png')); ?>" alt="image"></div>
        <div class="ball-3"><img src="<?php echo e(asset($activeTemplateTrue.'images/elements/ball-3.png')); ?>" alt="image"></div>
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="account-wrapper">
                        <form class="account-form" method="POST" action="<?php echo e(route('user.login')); ?>" onsubmit="return submitUserForm();">
                            <?php echo csrf_field(); ?>

                            <div class="account-thumb-area text-center">
                                <h3 class="title"><?php echo app('translator')->get('Welcome Back to'); ?> <?php echo e($general->sitename); ?></h3>
                            </div>
                            <div class="form-group">
                                <label><?php echo app('translator')->get('Username & Email'); ?> <sup class="text-danger">*</sup></label>
                                <input type="text" name="username" value="<?php echo e(old('username')); ?>" placeholder="<?php echo app('translator')->get('Username & Email'); ?>" class="form--control" required>
                            </div>
                            <div class="form-group">
                                <label><?php echo e(__('Password')); ?> <sup class="text-danger">*</sup></label>
                                <input id="password" type="password" class="form--control" placeholder="<?php echo app('translator')->get('Enter your password'); ?>" name="password" required>
                            </div>

                            <div class="form-group d-flex justify-content-center">
                                <div class="col-md-6">
                                    <?php echo loadReCaptcha() ?>
                                </div>
                            </div>
                            <?php echo $__env->make($activeTemplate.'partials.custom_captcha', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                            <div class="form-group text-end">
                                <a href="<?php echo e(route('user.password.request')); ?>" class="text-white"><?php echo app('translator')->get('Forget Password?'); ?></a>
                            </div>
                            <button type="submit" id="recaptcha" class="btn btn--base w-100"><?php echo app('translator')->get('Login Now'); ?></button>
                            <p class="text-center mt-3"><span class="text-white"><?php echo app('translator')->get('New to'); ?> <?php echo e($general->sitename); ?>?</span> <a href="<?php echo e(route('user.register')); ?>" class="text--base"><?php echo app('translator')->get('Register here'); ?></a></p>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- account section end -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        function submitUserForm() {
            var response = grecaptcha.getResponse();
            if (response.length == 0) {
                document.getElementById('g-recaptcha-error').innerHTML = '<span class="text-danger"><?php echo app('translator')->get("Captcha field is required."); ?></span>';
                return false;
            }
            return true;
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate.'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/embmininin/lottary.embminining.xyz/core/resources/views/templates/basic/user/auth/login.blade.php ENDPATH**/ ?>