<?php
    $testimonial_content = getContent('testimonial.content', true);
    $testimonial_elements = getContent('testimonial.element');
?>

<!-- testimonial section start -->
<section class="pt-50 pb-50">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                <div class="section-header text-center">
                    <h2 class="section-title"><?php echo e(__(@$testimonial_content->data_values->heading)); ?></h2>
                    <p class="mt-3"><?php echo e(__(@$testimonial_content->data_values->sub_heading)); ?></p>
                </div>
            </div>
        </div><!-- row end -->
        <div class="testimonial-slider">

            <?php $__empty_1 = true; $__currentLoopData = $testimonial_elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="single-slide">
                    <div class="testimonial-item rounded-3">
                        <div class="ratings">
                            <?php for($i = 0; $i < 5; $i++): ?>
                                <?php if($i < $item->data_values->rating): ?>
                                    <i class="las la-star"></i>
                                <?php else: ?>
                                    <i class="lar la-star"></i>
                                <?php endif; ?>
                            <?php endfor; ?>
                        </div>
                        <p class="text-white mt-2"><?php echo e(__(@$item->data_values->review)); ?></p>
                        <div class="client-details d-flex align-items-center mt-4">
                            <div class="thumb">
                                <img src="<?php echo e(getImage('assets/images/frontend/testimonial/' . @$item->data_values->image, '75x75')); ?>" alt="image">
                            </div>
                            <div class="content">
                                <h4 class="name text-white"><?php echo e(__(@$item->data_values->name)); ?></h4>
                                <span class="designation text-white-50 fs--14px"><?php echo e(__(@$item->data_values->designation)); ?></span>
                            </div>
                        </div>
                    </div><!-- testimonial-item end -->
                </div><!-- single-slide end -->
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <?php endif; ?>

        </div><!-- testimonial-slider end -->
    </div>
</section>
<!-- testimonial section end -->
<?php /**PATH /home/embmininin/lottary.embminining.xyz/core/resources/views/templates/basic/sections/testimonial.blade.php ENDPATH**/ ?>