<!doctype html>
<html lang="en" itemscope itemtype="http://schema.org/WebPage">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title> <?php echo e($general->sitename(__($pageTitle))); ?></title>
<?php echo $__env->make('partials.seo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<!-- bootstrap 5  -->
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/lib/bootstrap.min.css')); ?>">
    <!-- fontawesome 5  -->
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/all.min.css')); ?>">
    <!-- lineawesome font -->
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/line-awesome.min.css')); ?>">
    <!-- slick slider css -->
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/lib/slick.css')); ?>">
    <!-- main css -->
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/main.css')); ?>">

    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/bootstrap-fileinput.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue.'css/custom.css')); ?>">

    <link rel="stylesheet"
          href="<?php echo e(asset($activeTemplateTrue.'css/color.php?color='.$general->base_color.'&secondColor='.$general->secondary_color)); ?>">

    <?php echo $__env->yieldPushContent('style-lib'); ?>

    <?php echo $__env->yieldPushContent('style'); ?>
</head>
<body>

<?php echo $__env->yieldPushContent('fbComment'); ?>

<div class="preloader">
    <div class="preloader-container">
        <span class="animated-preloader"></span>
    </div>
</div>

<!-- scroll-to-top start -->
<div class="scroll-to-top">
    <span class="scroll-icon">
      <i class="fa fa-rocket" aria-hidden="true"></i>
    </span>
</div>
<!-- scroll-to-top end -->

<!-- header-section start  -->
<header class="header">
    <div class="header__bottom">
        <div class="container-fluid px-lg-5">
            <nav class="navbar navbar-expand-xl p-0 align-items-center">
                <a class="site-logo site-title" href="<?php echo e(route('home')); ?>"><img src="<?php echo e(getImage(imagePath()['logoIcon']['path'] .'/logo.png')); ?>" alt="logo"></a>
                <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                        data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                        aria-expanded="false" aria-label="Toggle navigation">
                    <span class="menu-toggle"></span>
                </button>
                <div class="collapse navbar-collapse mt-lg-0 mt-3" id="navbarSupportedContent">
                    <ul class="navbar-nav main-menu me-auto">
                        <li><a href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a></li>
                        <li><a href="<?php echo e(route('lottery')); ?>"><?php echo app('translator')->get('Lotteries'); ?></a></li>

                        <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><a href="<?php echo e(route('pages',[$data->slug])); ?>"><?php echo e(__($data->name)); ?></a></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <li><a href="<?php echo e(route('blog')); ?>"><?php echo app('translator')->get('Blog'); ?></a></li>
                        <li><a href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a></li>
                    </ul>
                    <div class="nav-right">
                        <?php if(auth()->guard()->check()): ?>
                            <a href="<?php echo e(route('user.home')); ?>" class="btn btn-sm btn--base me-sm-3 me-2 btn--capsule px-3"><?php echo app('translator')->get('Dashboard'); ?></a>
                            <a href="<?php echo e(route('user.logout')); ?>" class="text-white fs--14px me-sm-3 me-2"><?php echo app('translator')->get('Logout'); ?></a>
                        <?php else: ?>
                            <a href="<?php echo e(route('user.login')); ?>" class="btn btn-sm btn--base me-sm-3 me-2 btn--capsule px-3"><?php echo app('translator')->get('Login'); ?></a>
                            <a href="<?php echo e(route('user.register')); ?>" class="text-white fs--14px me-sm-3 me-2"><?php echo app('translator')->get('Register'); ?></a>
                        <?php endif; ?>
                        <select class="language-select langSel">
                            <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                            <?php $__currentLoopData = $language; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->code); ?>" <?php if(session('lang') == $item->code): ?> selected  <?php endif; ?>><?php echo e(__($item->name)); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
            </nav>
        </div>
    </div><!-- header__bottom end -->
</header>
<!-- header-section end  -->

<div class="main-wrapper">

    <?php if(!request()->routeIs('home')): ?>
        <?php echo $__env->make($activeTemplate.'partials.breadcrumb', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>

    <?php echo $__env->yieldContent('content'); ?>

</div><!-- main-wrapper end -->

<?php
    $footer_content = getContent('footer.content', true);
    $footer_elements = getContent('footer.element');
    $extra_pages = getContent('extra.element');
?>
<!-- footer start -->
<footer class="footer">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-2 col-md-3 text-md-start text-center">
                <a href="<?php echo e(route('home')); ?>" class="footer-logo"><img src="<?php echo e(getImage(imagePath()['logoIcon']['path'] .'/logo.png')); ?>" alt="image"></a>
            </div>
            <div class="col-lg-10 col-md-9 mt-md-0 mt-3">
                <ul class="inline-menu d-flex flex-wrap justify-content-md-end justify-content-center align-items-center">
                    <li><a href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a></li>
                    <li><a href="<?php echo e(route('lottery')); ?>"><?php echo app('translator')->get('Lotteries'); ?></a></li>

                    <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><a href="<?php echo e(route('pages',[$data->slug])); ?>"><?php echo e(__($data->name)); ?></a></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php $__empty_1 = true; $__currentLoopData = $extra_pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <li><a href="<?php echo e(route('links',[$item->id,slug($item->data_values->title)])); ?>"><?php echo e(__(@$item->data_values->title)); ?></a></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <?php endif; ?>
                </ul>
            </div>
        </div><!-- row end -->
        <hr class="mt-3">
        <div class="row align-items-center">
            <div class="col-md-6 text-md-start text-center">
                <p><?php echo e(__(@$footer_content->data_values->copyright)); ?></p>
            </div>
            <div class="col-md-6 mt-md-0 mt-3">
                <ul class="inline-social-links d-flex align-items-center justify-content-md-end justify-content-center">
                    <?php $__empty_1 = true; $__currentLoopData = $footer_elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <li><a href="<?php echo e(@$item->data_values->social_link); ?>" target="_blank"><?php echo @$item->data_values->social_icon ?></a></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </div>
</footer>
<!-- footer end -->


<?php
    $cookie = App\Models\Frontend::where('data_keys','cookie.data')->first();
?>
<?php if(@$cookie->data_values->status && !session('cookie_accepted')): ?>
    <div class="cookie__wrapper">
        <div class="container">
            <div class="d-flex flex-wrap align-items-center justify-content-between">
                <p class="txt my-2">

                    <?php echo @$cookie->data_values->description ?>

                    <a href="<?php echo e(@$cookie->data_values->link); ?>" target="_blank" class="text--base"><?php echo app('translator')->get('Read Policy'); ?></a>
                </p>
                <button class="btn btn--base btn-md my-2 acceptPolicy">Accept</button>
            </div>
        </div>
    </div>
<?php endif; ?>


<!-- jQuery library -->
<script src="<?php echo e(asset($activeTemplateTrue.'js/lib/jquery-3.6.0.min.js')); ?>"></script>
<!-- bootstrap js -->
<script src="<?php echo e(asset($activeTemplateTrue.'js/lib/bootstrap.bundle.min.js')); ?>"></script>
<!-- slick slider js -->
<script src="<?php echo e(asset($activeTemplateTrue.'js/lib/slick.min.js')); ?>"></script>
<!-- scroll animation -->
<script src="<?php echo e(asset($activeTemplateTrue.'js/lib/wow.min.js')); ?>"></script>
<!-- apex chart js -->
<script src="<?php echo e(asset($activeTemplateTrue.'js/lib/jquery.countdown.js')); ?>"></script>
<!-- main js -->
<script src="<?php echo e(asset($activeTemplateTrue.'js/app.js')); ?>"></script>

<?php echo $__env->yieldPushContent('script-lib'); ?>

<?php echo $__env->yieldPushContent('script'); ?>

<?php echo $__env->make('partials.plugins', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->make('partials.notify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<script>
    (function ($) {
        "use strict";
        $(".langSel").on("change", function () {
            window.location.href = "<?php echo e(route('home')); ?>/change/" + $(this).val();
        });

        //Cookie
        $(document).on('click', '.acceptPolicy', function () {
            $.ajax({
                url: "<?php echo e(route('cookie.accept')); ?>",
                method:'GET',
                success:function(data){
                    if (data.success){
                        $('.cookie__wrapper').addClass('d-none');
                        notify('success', data.success)
                    }
                },
            });
        });
    })(jQuery);
</script>

</body>
</html>
<?php /**PATH /home/embmininin/lottary.embminining.xyz/core/resources/views/templates/basic/layouts/frontend.blade.php ENDPATH**/ ?>