<?php
    $lottery_content = getContent('lottery.content', true);
    $time = \Carbon\Carbon::now()->toDateTimeString();
    $phases = \App\Models\Phase::where('status',1)->where('draw_status',0)->where('start','<',$time)->orderBy('end')->whereHas('lottery',function($lottery){
          $lottery->where('status',1);
      })->limit(3)->with(['lottery'])->get();
?>
<!-- lottery calender section start -->
<section class="pt-50 pb-50">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-6">
                <div class="section-header text-center">
                    <h2 class="section-title"><?php echo e(__(@$lottery_content->data_values->heading)); ?></h2>
                </div>
            </div>
        </div><!-- row end -->
        <div class="row">
            <div class="col-lg-12">
                <div class="table-responsive--md">
                    <table class="table custom--table">
                        <thead>
                        <tr>
                            <th><?php echo app('translator')->get('Title'); ?></th>
                            <th><?php echo app('translator')->get('Start Date'); ?></th>
                            <th><?php echo app('translator')->get('End Date'); ?></th>
                            <th><?php echo app('translator')->get('Price'); ?></th>
                            <th><?php echo app('translator')->get('Sold'); ?></th>
                            <th><?php echo app('translator')->get('Status'); ?></th>
                            <th><?php echo app('translator')->get('Action'); ?></th>
                        </tr>
                        </thead>
                        <tbody>

                        <?php $__empty_1 = true; $__currentLoopData = $phases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td data-label="<?php echo app('translator')->get('Title'); ?>">
                                    <div class="table-game">
                                        <img src="<?php echo e(getImage('assets/images/lottery/'.$phase->lottery->image,imagePath()['lottery']['size'])); ?>" alt="image">
                                        <h6 class="name"><?php echo e(__($phase->lottery->name)); ?></h6>
                                    </div>
                                </td>
                                <td data-label="<?php echo app('translator')->get('Start Date'); ?>"><?php echo e(@showDateTime($phase->start, 'Y-m-d')); ?></td>
                                <td data-label="<?php echo app('translator')->get('End Date'); ?>"><?php echo e(@showDateTime($phase->end, 'Y-m-d')); ?></td>
                                <td data-label="<?php echo app('translator')->get('Price'); ?>"><?php echo e(showAmount($phase->lottery->price)); ?> <?php echo e($general->cur_text); ?></td>
                                <td data-label="<?php echo app('translator')->get('Sold'); ?>">
                                    <div class="progress lottery--progress">
                                        <div class="progress-bar progress-bar-striped progress-bar-animated"
                                             role="progressbar" aria-valuenow="<?php echo e(($phase->salled/$phase->quantity)*100); ?>" aria-valuemin="0" aria-valuemax="100"
                                             style="width: <?php echo e(($phase->salled/$phase->quantity)*100); ?>%"></div>
                                    </div>
                                    <span class="fs--14px"><?php echo e(($phase->salled/$phase->quantity)*100); ?>%</span>
                                </td>
                                <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                    <?php if($phase->draw_status == 1): ?>
                                        <?php echo app('translator')->get('Draw Complete'); ?>
                                    <?php elseif($phase->end < Carbon\Carbon::now()): ?>
                                        <?php echo app('translator')->get('Waiting For Draw'); ?>
                                    <?php else: ?>
                                        <?php echo app('translator')->get('Running'); ?>
                                    <?php endif; ?>
                                </td>
                                <td data-label="<?php echo app('translator')->get('Action'); ?>"><a href="<?php echo e(route('lotterySingle',$phase->id)); ?>" class="btn btn-sm btn-outline--base"><?php echo app('translator')->get('Buy Ticket'); ?></a></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <?php endif; ?>

                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        <div class="text-center">
            <a href="<?php echo e(route('lottery')); ?>" class="btn btn--base btn--capsule mt-3 wow fadeInUp" data-wow-duration="0.5s" data-wow-delay="0.7s"><?php echo app('translator')->get('View All'); ?></a>
        </div>
    </div>
</section>
<!-- lottery calender section end -->
<?php /**PATH /home/embmininin/lottary.embminining.xyz/core/resources/views/templates/basic/sections/lottery.blade.php ENDPATH**/ ?>