<?php
    $statistics_content = getContent('statistics.content', true);
    $time = \Carbon\Carbon::now()->toDateTimeString();
    $phases = \App\Models\Phase::where('status',1)->where('draw_status',1)->where('start','<',$time)->orderBy('end')->whereHas('lottery',function($lottery){
          $lottery->where('status',1);
      })->limit(3)->with(['lottery'])->get();
?>
<!-- statistics section start -->
<section class="pt-50 pb-100">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="section-header">
                    <h2 class="section-title"><?php echo e(__(@$statistics_content->data_values->heading)); ?></h2>
                </div>
            </div>
        </div><!-- row end -->
        <div class="row gy-4 justify-content-center">

            <?php $__empty_1 = true; $__currentLoopData = $phases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="col-lg-4 col-md-6">
                    <div class="stat-card">
                        <div class="stat-card__header">
                            <div class="thumb"><img src="<?php echo e(getImage('assets/images/lottery/'.$phase->lottery->image,imagePath()['lottery']['size'])); ?>" alt="image"></div>
                            <div class="content">
                                <h3 class="title"><?php echo e(__($phase->lottery->name)); ?></h3>
                            </div>
                        </div>
                        <ul class="caption-list-two mt-3">
                            <li>
                                <span class="caption"><?php echo app('translator')->get('Total Bet'); ?></span>
                                <span class="value text-end text--base"><?php echo e($phase->salled); ?></span>
                            </li>
                            <li>
                                <span class="caption"><?php echo app('translator')->get('Draw Date'); ?></span>
                                <span class="value text-end text--base"><?php echo e(showDateTime($phase->end,'d/m/y')); ?></span>
                            </li>
                            <li>
                                <span class="caption"><?php echo app('translator')->get('Winners'); ?></span>
                                <span class="value text-end text--base"><?php echo e(@$phase->winners->count()); ?></span>
                            </li>
                        </ul>
                    </div><!-- stat-card end -->
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <?php endif; ?>

        </div>
    </div>
</section>
<!-- statistics section end -->
<?php /**PATH /home/embmininin/lottary.embminining.xyz/core/resources/views/templates/basic/sections/statistics.blade.php ENDPATH**/ ?>